//Aim:Obtain different types of plots (2D,surface plot,polar plot).
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
//plot for 2D
figure()
x =-10: 0.1 : 10;// Define your x-values
y =cos(x).*sinc(x);// Define your function
plot(x, y)
title('2D plot')
xlabel('x axis');
ylabel('y axis');
legend('y =cos(x).*sinc(x)');

//plot for polar plot
figure()
t = linspace(0, 2*%pi, 100);
r =sqrt(abs(2 * sinc(5*t)));
title('polar plot')
polarplot(t, r);

//plot for surface plot
figure()
t=[0:0.3:2*%pi]';
z=sin(t)*cos(t');
xlabel('x axis');
ylabel('y axis');
zlabel('z axis');
title('surface plot');
plot3d(t,t,z)
